SELECT p.name AS POLICY_NAME,
       CASE WHEN mf.execution_mode & 4 = 4
               THEN 1 ELSE 0
       END AS EVAL_ON_DEMAND,
       CASE WHEN mf.execution_mode & 4 = 4
               THEN 1 ELSE 0
       END AS EVAL_ON_SCHEDULE,
       CASE WHEN mf.execution_mode & 2 = 2
               THEN 1 ELSE 0
       END AS EVAL_ON_CHANGE_LOG_ONLY,
       CASE WHEN mf.execution_mode & 1 = 1
               THEN 1 ELSE 0
       END AS EVAL_ON_CHANGE_PREVENT
FROM   msdb.dbo.syspolicy_policies AS p
       INNER JOIN msdb.dbo.syspolicy_conditions AS c
             ON p.condition_id = c.condition_id
       INNER JOIN msdb.dbo.syspolicy_management_facets AS mf
             ON c.facet = mf.name;